/*
  This file is part of YUMI

  It is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with it. If not, see <https://www.gnu.org/licenses/>.

  Copyright https://www.pendrivelinux.com (See YUMI-Copying.txt and YUMI-Readme.txt for more information, Credits, and Licensing)
*/

; ------------- DriveStuff -------------
 
Function PhysDrive
 StrCpy $1 "$JustDrive"
 Push $1
 Call HDDNumber1  ;HDDNumber
 StrCpy $DiskNum $9 ;0
FunctionEnd

Function prePhysDrive
 StrCpy $1 "$preJustDrive"
 Push $1
 Call HDDNumber1  ;HDDNumber
 StrCpy $DiskNum $9 ;0
FunctionEnd

/* Function PhysDriveName
 ;StrCpy $1 "$JustDrive" 2
 StrCpy $1 "$DiskNum"
 ;Push $1
 Call GetDiskInfoByDiskNumber
 Pop $PDriveName
 StrCpy $PDriveName $2
 MessageBox MB_OK "Physical Drive Name for |$1| - $2 - $PDriveName"
FunctionEnd */
 
Function PopNum
 StrCpy $1 "$3"
 Push $1
 Call HDDNumber1
 StrCpy $DiskNum $9
FunctionEnd
 
/* ; Might need this again sometime
Function Lock_Only
 StrCpy $1 "\\.\$JustDrive" -1
 Push $1
 Call Create
 Call LockVol 
FunctionEnd		 */
		  
; The following code was found here: http://forums.winamp.com/showthread.php?t=317579
; File Access Modes
!define GENERIC_READ         0x80000000
!define GENERIC_WRITE        0x40000000

; File Sharing Modes
!define FILE_SHARE_READ      0x00000001
!define FILE_SHARE_WRITE     0x00000002

; File Creation Flags
!define OPEN_EXISTING        3
!define INVALID_HANDLE_VALUE -1

; Maximum length of volume GUID (including terminating zero)
!define MAXLEN_VOLUME_GUID   51

; I/O control command
!define IOCTL_VOLUME_GET_VOLUME_DISK_EXTENTS   0x00560000
!define EXTENTS_BUFFER_SIZE  512
; Dismount_Volume
!define FSCTL_DISMOUNT_VOLUME 0x00090020

; Lock_Volume
!define FSCTL_LOCK_VOLUME 0x00090018

; Unlock_Volume
!define FSCTL_UNLOCK_VOLUME 0x0009001c										
; Get hard disk number from drive letter
; provided as a parameter to this function.
; The hard disk number is returned in $9.

Function HDDNumber1
    Exch $1
    Push $2
    Push $3
    Push $4
    Push $5
    Push $6
    Push $7

    System::Call "kernel32::GetVolumeNameForVolumeMountPoint(t r1, t r3r3, i ${MAXLEN_VOLUME_GUID}) i.r2"
    ${If} $2 != 0
        StrCpy $3 $3 -1
        System::Call "kernel32::CreateFile(t r3, \\
            i ${GENERIC_READ}|${GENERIC_WRITE}, \\
            i ${FILE_SHARE_READ}|${FILE_SHARE_WRITE}, \\
            i 0, i ${OPEN_EXISTING}, i 0, i 0) i.r2"
        ${If} $2 != ${INVALID_HANDLE_VALUE}
            System::Alloc ${EXTENTS_BUFFER_SIZE}
            Pop $4
            IntOp $5 0 + 0
            System::Call "kernel32::DeviceIoControl(i r2, \\
                i ${IOCTL_VOLUME_GET_VOLUME_DISK_EXTENTS}, \\
                i 0, i 0, \\
                i r4, i ${EXTENTS_BUFFER_SIZE}, \\
                *i r5r5, i 0) i.r3"
            ${If} $3 != 0
                System::Call "*$4(i .r5, i, i .r9)"
                ${If} $5 == 0
                    StrCpy $9 "Error: Invalid DISK_EXTENT data"
                ${EndIf}
            ${Else}
                StrCpy $9 "Error: DeviceIoControl failed"
            ${EndIf}
            System::Free $4
            System::Call "kernel32::CloseHandle(i r2) i.r3"
        ${Else}
            StrCpy $9 "Error: CreateFile failed for $3"
        ${EndIf}
    ${Else}
        StrCpy $9 "Error: GetVolumeNameForVolumeMountPoint failed for $1"
    ${EndIf}

    Pop $7
    Pop $6
    Pop $5
    Pop $4
    Pop $3
    Pop $2
    Pop $1
FunctionEnd 

!define CLSID_WbemLocator "{4590F811-1D3A-11D0-891F-00AA004B2E24}"
!define IID_IWbemLocator "{DC12A687-737F-11CF-884D-00AA004B2E24}"
!define CLSID_SWbemLocator "{76A64158-CB41-11D1-8B02-00600806D9B6}"

!define MAX_PATH 260
!define DIGCF_PRESENT 0x00000002
!define DICS_FLAG_GLOBAL 0x00000004
!define DIREG_DEV 0x00000001

/* Function GetDiskInfoByDiskNumber
    ; Create a WMI query to retrieve information about the disk by its index
    StrCpy $2 "SELECT * FROM Win32_DiskDrive WHERE Index = $1"

    ; Execute the WMI query
    System::Call 'ole32::CoInitialize(i0) i.r1'
    System::Call 'ole32::CoCreateInstance(g "${CLSID_WbemLocator}", i 0, i 1, g "${IID_IWbemLocator}", i.r2)'
    System::Call 'r2->2(i "${CLSID_SWbemLocator}", i 0, i 1, i.r3)'
    System::Call 'r3->11(t "$2", i 0x00000020, i0, i.r4, i0)'

    ; Check for query success
    ${If} $4 == 0
        ; Get the first item (there should only be one)
        System::Call 'r4->3(i0, i.r5)'

        ; Retrieve information from the WMI object
        System::Call 'r5->5(t.r6)' ; Manufacturer
        System::Call 'r5->7(t.r7)' ; Model
        System::Call 'r5->12(i.r8)' ; Size in bytes

        ; Format the disk information
        StrCpy $2 "Manufacturer: $6$\r$\nModel: $7$\r$\nSize: $8 bytes"

        ; Uninitialize COM
        System::Call 'ole32::CoUninitialize()'
    ${Else}
        ; Set an error message if the query fails
        StrCpy $2 "Error: Unable to retrieve disk information"
    ${EndIf}
FunctionEnd */



Function GetVolNameDSK
nsExec::ExecToLog '"cmd" /c for /f %D in ($\'wmic volume get DriveLetter^, Label ^| find "$VHDLBL"$\') do echo %D > $DestDisk\dskvol.txt'
FileOpen $1 "$DestDisk\dskvol.txt" r
FileRead $1 $VHDDisk
FileClose $1
FunctionEnd